
;CodeVisionAVR C Compiler V1.25.9 Standard
;(C) Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;http://www.hpinfotech.com

;Chip type              : ATmega32
;Program type           : Application
;Clock frequency        : 4,000000 MHz
;Memory model           : Small
;Optimize for           : Size
;(s)printf features     : int, width
;(s)scanf features      : int, width
;External SRAM size     : 0
;Data Stack size        : 512 byte(s)
;Heap size              : 0 byte(s)
;Promote char to int    : No
;char is unsigned       : Yes
;8 bit enums            : Yes
;Word align FLASH struct: No
;Enhanced core instructions    : On
;Smart register allocation : On
;Automatic register allocation : On

	#pragma AVRPART ADMIN PART_NAME ATmega32
	#pragma AVRPART MEMORY PROG_FLASH 32768
	#pragma AVRPART MEMORY EEPROM 1024
	#pragma AVRPART MEMORY INT_SRAM SIZE 2048
	#pragma AVRPART MEMORY INT_SRAM START_ADDR 0x60

	.EQU UDRE=0x5
	.EQU RXC=0x7
	.EQU USR=0xB
	.EQU UDR=0xC
	.EQU SPSR=0xE
	.EQU SPDR=0xF
	.EQU EERE=0x0
	.EQU EEWE=0x1
	.EQU EEMWE=0x2
	.EQU EECR=0x1C
	.EQU EEDR=0x1D
	.EQU EEARL=0x1E
	.EQU EEARH=0x1F
	.EQU WDTCR=0x21
	.EQU MCUCR=0x35
	.EQU GICR=0x3B
	.EQU SPL=0x3D
	.EQU SPH=0x3E
	.EQU SREG=0x3F

	.DEF R0X0=R0
	.DEF R0X1=R1
	.DEF R0X2=R2
	.DEF R0X3=R3
	.DEF R0X4=R4
	.DEF R0X5=R5
	.DEF R0X6=R6
	.DEF R0X7=R7
	.DEF R0X8=R8
	.DEF R0X9=R9
	.DEF R0XA=R10
	.DEF R0XB=R11
	.DEF R0XC=R12
	.DEF R0XD=R13
	.DEF R0XE=R14
	.DEF R0XF=R15
	.DEF R0X10=R16
	.DEF R0X11=R17
	.DEF R0X12=R18
	.DEF R0X13=R19
	.DEF R0X14=R20
	.DEF R0X15=R21
	.DEF R0X16=R22
	.DEF R0X17=R23
	.DEF R0X18=R24
	.DEF R0X19=R25
	.DEF R0X1A=R26
	.DEF R0X1B=R27
	.DEF R0X1C=R28
	.DEF R0X1D=R29
	.DEF R0X1E=R30
	.DEF R0X1F=R31

	.MACRO __CPD1N
	CPI  R30,LOW(@0)
	LDI  R26,HIGH(@0)
	CPC  R31,R26
	LDI  R26,BYTE3(@0)
	CPC  R22,R26
	LDI  R26,BYTE4(@0)
	CPC  R23,R26
	.ENDM

	.MACRO __CPD2N
	CPI  R26,LOW(@0)
	LDI  R30,HIGH(@0)
	CPC  R27,R30
	LDI  R30,BYTE3(@0)
	CPC  R24,R30
	LDI  R30,BYTE4(@0)
	CPC  R25,R30
	.ENDM

	.MACRO __CPWRR
	CP   R@0,R@2
	CPC  R@1,R@3
	.ENDM

	.MACRO __CPWRN
	CPI  R@0,LOW(@2)
	LDI  R30,HIGH(@2)
	CPC  R@1,R30
	.ENDM

	.MACRO __ADDB1MN
	SUBI R30,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDB2MN
	SUBI R26,LOW(-@0-(@1))
	.ENDM
	.MACRO __ADDW1MN
	SUBI R30,LOW(-@0-(@1))
	SBCI R31,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW2MN
	SUBI R26,LOW(-@0-(@1))
	SBCI R27,HIGH(-@0-(@1))
	.ENDM
	.MACRO __ADDW1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1FN
	SUBI R30,LOW(-2*@0-(@1))
	SBCI R31,HIGH(-2*@0-(@1))
	SBCI R22,BYTE3(-2*@0-(@1))
	.ENDM
	.MACRO __ADDD1N
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	SBCI R22,BYTE3(-@0)
	SBCI R23,BYTE4(-@0)
	.ENDM

	.MACRO __ADDD2N
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	SBCI R24,BYTE3(-@0)
	SBCI R25,BYTE4(-@0)
	.ENDM

	.MACRO __SUBD1N
	SUBI R30,LOW(@0)
	SBCI R31,HIGH(@0)
	SBCI R22,BYTE3(@0)
	SBCI R23,BYTE4(@0)
	.ENDM

	.MACRO __SUBD2N
	SUBI R26,LOW(@0)
	SBCI R27,HIGH(@0)
	SBCI R24,BYTE3(@0)
	SBCI R25,BYTE4(@0)
	.ENDM

	.MACRO __ANDBMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ANDWMNN
	LDS  R30,@0+@1
	ANDI R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ANDI R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ANDD1N
	ANDI R30,LOW(@0)
	ANDI R31,HIGH(@0)
	ANDI R22,BYTE3(@0)
	ANDI R23,BYTE4(@0)
	.ENDM

	.MACRO __ORBMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	.ENDM

	.MACRO __ORWMNN
	LDS  R30,@0+@1
	ORI  R30,LOW(@2)
	STS  @0+@1,R30
	LDS  R30,@0+@1+1
	ORI  R30,HIGH(@2)
	STS  @0+@1+1,R30
	.ENDM

	.MACRO __ORD1N
	ORI  R30,LOW(@0)
	ORI  R31,HIGH(@0)
	ORI  R22,BYTE3(@0)
	ORI  R23,BYTE4(@0)
	.ENDM

	.MACRO __DELAY_USB
	LDI  R24,LOW(@0)
__DELAY_USB_LOOP:
	DEC  R24
	BRNE __DELAY_USB_LOOP
	.ENDM

	.MACRO __DELAY_USW
	LDI  R24,LOW(@0)
	LDI  R25,HIGH(@0)
__DELAY_USW_LOOP:
	SBIW R24,1
	BRNE __DELAY_USW_LOOP
	.ENDM

	.MACRO __CLRD1S
	LDI  R30,0
	STD  Y+@0,R30
	STD  Y+@0+1,R30
	STD  Y+@0+2,R30
	STD  Y+@0+3,R30
	.ENDM

	.MACRO __GETD1S
	LDD  R30,Y+@0
	LDD  R31,Y+@0+1
	LDD  R22,Y+@0+2
	LDD  R23,Y+@0+3
	.ENDM

	.MACRO __PUTD1S
	STD  Y+@0,R30
	STD  Y+@0+1,R31
	STD  Y+@0+2,R22
	STD  Y+@0+3,R23
	.ENDM

	.MACRO __PUTD2S
	STD  Y+@0,R26
	STD  Y+@0+1,R27
	STD  Y+@0+2,R24
	STD  Y+@0+3,R25
	.ENDM

	.MACRO __POINTB1MN
	LDI  R30,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW1MN
	LDI  R30,LOW(@0+@1)
	LDI  R31,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTD1M
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __POINTW1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	.ENDM

	.MACRO __POINTD1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	LDI  R22,BYTE3(2*@0+@1)
	LDI  R23,BYTE4(2*@0+@1)
	.ENDM

	.MACRO __POINTB2MN
	LDI  R26,LOW(@0+@1)
	.ENDM

	.MACRO __POINTW2MN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	.ENDM

	.MACRO __POINTBRM
	LDI  R@0,LOW(@1)
	.ENDM

	.MACRO __POINTWRM
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __POINTBRMN
	LDI  R@0,LOW(@1+@2)
	.ENDM

	.MACRO __POINTWRMN
	LDI  R@0,LOW(@2+@3)
	LDI  R@1,HIGH(@2+@3)
	.ENDM

	.MACRO __POINTWRFN
	LDI  R@0,LOW(@2*2+@3)
	LDI  R@1,HIGH(@2*2+@3)
	.ENDM

	.MACRO __GETD1N
	LDI  R30,LOW(@0)
	LDI  R31,HIGH(@0)
	LDI  R22,BYTE3(@0)
	LDI  R23,BYTE4(@0)
	.ENDM

	.MACRO __GETD2N
	LDI  R26,LOW(@0)
	LDI  R27,HIGH(@0)
	LDI  R24,BYTE3(@0)
	LDI  R25,BYTE4(@0)
	.ENDM

	.MACRO __GETD2S
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	LDD  R24,Y+@0+2
	LDD  R25,Y+@0+3
	.ENDM

	.MACRO __GETB1MN
	LDS  R30,@0+@1
	.ENDM

	.MACRO __GETB1HMN
	LDS  R31,@0+@1
	.ENDM

	.MACRO __GETW1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	.ENDM

	.MACRO __GETD1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	LDS  R22,@0+@1+2
	LDS  R23,@0+@1+3
	.ENDM

	.MACRO __GETBRMN
	LDS  R@0,@1+@2
	.ENDM

	.MACRO __GETWRMN
	LDS  R@0,@2+@3
	LDS  R@1,@2+@3+1
	.ENDM

	.MACRO __GETWRZ
	LDD  R@0,Z+@2
	LDD  R@1,Z+@2+1
	.ENDM

	.MACRO __GETD2Z
	LDD  R26,Z+@0
	LDD  R27,Z+@0+1
	LDD  R24,Z+@0+2
	LDD  R25,Z+@0+3
	.ENDM

	.MACRO __GETB2MN
	LDS  R26,@0+@1
	.ENDM

	.MACRO __GETW2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	.ENDM

	.MACRO __GETD2MN
	LDS  R26,@0+@1
	LDS  R27,@0+@1+1
	LDS  R24,@0+@1+2
	LDS  R25,@0+@1+3
	.ENDM

	.MACRO __PUTB1MN
	STS  @0+@1,R30
	.ENDM

	.MACRO __PUTW1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	.ENDM

	.MACRO __PUTD1MN
	STS  @0+@1,R30
	STS  @0+@1+1,R31
	STS  @0+@1+2,R22
	STS  @0+@1+3,R23
	.ENDM

	.MACRO __PUTBR0MN
	STS  @0+@1,R0
	.ENDM

	.MACRO __PUTDZ2
	STD  Z+@0,R26
	STD  Z+@0+1,R27
	STD  Z+@0+2,R24
	STD  Z+@0+3,R25
	.ENDM

	.MACRO __PUTBMRN
	STS  @0+@1,R@2
	.ENDM

	.MACRO __PUTWMRN
	STS  @0+@1,R@2
	STS  @0+@1+1,R@3
	.ENDM

	.MACRO __PUTBZR
	STD  Z+@1,R@0
	.ENDM

	.MACRO __PUTWZR
	STD  Z+@2,R@0
	STD  Z+@2+1,R@1
	.ENDM

	.MACRO __GETW1R
	MOV  R30,R@0
	MOV  R31,R@1
	.ENDM

	.MACRO __GETW2R
	MOV  R26,R@0
	MOV  R27,R@1
	.ENDM

	.MACRO __GETWRN
	LDI  R@0,LOW(@2)
	LDI  R@1,HIGH(@2)
	.ENDM

	.MACRO __PUTW1R
	MOV  R@0,R30
	MOV  R@1,R31
	.ENDM

	.MACRO __PUTW2R
	MOV  R@0,R26
	MOV  R@1,R27
	.ENDM

	.MACRO __ADDWRN
	SUBI R@0,LOW(-@2)
	SBCI R@1,HIGH(-@2)
	.ENDM

	.MACRO __ADDWRR
	ADD  R@0,R@2
	ADC  R@1,R@3
	.ENDM

	.MACRO __SUBWRN
	SUBI R@0,LOW(@2)
	SBCI R@1,HIGH(@2)
	.ENDM

	.MACRO __SUBWRR
	SUB  R@0,R@2
	SBC  R@1,R@3
	.ENDM

	.MACRO __ANDWRN
	ANDI R@0,LOW(@2)
	ANDI R@1,HIGH(@2)
	.ENDM

	.MACRO __ANDWRR
	AND  R@0,R@2
	AND  R@1,R@3
	.ENDM

	.MACRO __ORWRN
	ORI  R@0,LOW(@2)
	ORI  R@1,HIGH(@2)
	.ENDM

	.MACRO __ORWRR
	OR   R@0,R@2
	OR   R@1,R@3
	.ENDM

	.MACRO __EORWRR
	EOR  R@0,R@2
	EOR  R@1,R@3
	.ENDM

	.MACRO __GETWRS
	LDD  R@0,Y+@2
	LDD  R@1,Y+@2+1
	.ENDM

	.MACRO __PUTWSR
	STD  Y+@2,R@0
	STD  Y+@2+1,R@1
	.ENDM

	.MACRO __MOVEWRR
	MOV  R@0,R@2
	MOV  R@1,R@3
	.ENDM

	.MACRO __INWR
	IN   R@0,@2
	IN   R@1,@2+1
	.ENDM

	.MACRO __OUTWR
	OUT  @2+1,R@1
	OUT  @2,R@0
	.ENDM

	.MACRO __CALL1MN
	LDS  R30,@0+@1
	LDS  R31,@0+@1+1
	ICALL
	.ENDM

	.MACRO __CALL1FN
	LDI  R30,LOW(2*@0+@1)
	LDI  R31,HIGH(2*@0+@1)
	CALL __GETW1PF
	ICALL
	.ENDM

	.MACRO __CALL2EN
	LDI  R26,LOW(@0+@1)
	LDI  R27,HIGH(@0+@1)
	CALL __EEPROMRDW
	ICALL
	.ENDM

	.MACRO __GETW1STACK
	IN   R26,SPL
	IN   R27,SPH
	ADIW R26,@0+1
	LD   R30,X+
	LD   R31,X
	.ENDM

	.MACRO __NBST
	BST  R@0,@1
	IN   R30,SREG
	LDI  R31,0x40
	EOR  R30,R31
	OUT  SREG,R30
	.ENDM


	.MACRO __PUTB1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SN
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNS
	LDD  R26,Y+@0
	LDD  R27,Y+@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMN
	LDS  R26,@0
	LDS  R27,@0+1
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1PMNS
	LDS  R26,@0
	LDS  R27,@0+1
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RN
	MOVW R26,R@0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RNS
	MOVW R26,R@0
	ADIW R26,@1
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RNS
	MOVW R26,R@0
	ADIW R26,@1
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RON
	MOV  R26,R@0
	MOV  R27,R@1
	SUBI R26,LOW(-@2)
	SBCI R27,HIGH(-@2)
	CALL __PUTDP1
	.ENDM

	.MACRO __PUTB1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X,R30
	.ENDM

	.MACRO __PUTW1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1RONS
	MOV  R26,R@0
	MOV  R27,R@1
	ADIW R26,@2
	CALL __PUTDP1
	.ENDM


	.MACRO __GETB1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R30,Z
	.ENDM

	.MACRO __GETB1HSX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	.ENDM

	.MACRO __GETW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R31,Z
	MOV  R30,R0
	.ENDM

	.MACRO __GETD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R0,Z+
	LD   R1,Z+
	LD   R22,Z+
	LD   R23,Z
	MOVW R30,R0
	.ENDM

	.MACRO __GETB2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R26,X
	.ENDM

	.MACRO __GETW2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	.ENDM

	.MACRO __GETD2SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R1,X+
	LD   R24,X+
	LD   R25,X
	MOVW R26,R0
	.ENDM

	.MACRO __GETBRSX
	MOVW R30,R28
	SUBI R30,LOW(-@1)
	SBCI R31,HIGH(-@1)
	LD   R@0,Z
	.ENDM

	.MACRO __GETWRSX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	LD   R@0,Z+
	LD   R@1,Z
	.ENDM

	.MACRO __LSLW8SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	LD   R31,Z
	CLR  R30
	.ENDM

	.MACRO __PUTB1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __CLRW1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __CLRD1SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	CLR  R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z+,R0
	ST   Z,R0
	.ENDM

	.MACRO __PUTB2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R26
	.ENDM

	.MACRO __PUTW2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z,R27
	.ENDM

	.MACRO __PUTD2SX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z+,R26
	ST   Z+,R27
	ST   Z+,R24
	ST   Z,R25
	.ENDM

	.MACRO __PUTBSRX
	MOVW R30,R28
	SUBI R30,LOW(-@0)
	SBCI R31,HIGH(-@0)
	ST   Z,R@1
	.ENDM

	.MACRO __PUTWSRX
	MOVW R30,R28
	SUBI R30,LOW(-@2)
	SBCI R31,HIGH(-@2)
	ST   Z+,R@0
	ST   Z,R@1
	.ENDM

	.MACRO __PUTB1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X,R30
	.ENDM

	.MACRO __PUTW1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X,R31
	.ENDM

	.MACRO __PUTD1SNX
	MOVW R26,R28
	SUBI R26,LOW(-@0)
	SBCI R27,HIGH(-@0)
	LD   R0,X+
	LD   R27,X
	MOV  R26,R0
	SUBI R26,LOW(-@1)
	SBCI R27,HIGH(-@1)
	ST   X+,R30
	ST   X+,R31
	ST   X+,R22
	ST   X,R23
	.ENDM

	.MACRO __MULBRR
	MULS R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRRU
	MUL  R@0,R@1
	MOVW R30,R0
	.ENDM

	.MACRO __MULBRR0
	MULS R@0,R@1
	.ENDM

	.MACRO __MULBRRU0
	MUL  R@0,R@1
	.ENDM

	.MACRO __MULBNWRU
	LDI  R26,@2
	MUL  R26,R@0
	MOVW R30,R0
	MUL  R26,R@1
	ADD  R31,R0
	.ENDM

	.CSEG
	.ORG 0

	.INCLUDE "ternary dac 5bit 243step.vec"
	.INCLUDE "ternary dac 5bit 243step.inc"

__RESET:
	CLI
	CLR  R30
	OUT  EECR,R30

;INTERRUPT VECTORS ARE PLACED
;AT THE START OF FLASH
	LDI  R31,1
	OUT  GICR,R31
	OUT  GICR,R30
	OUT  MCUCR,R30

;DISABLE WATCHDOG
	LDI  R31,0x18
	OUT  WDTCR,R31
	OUT  WDTCR,R30

;CLEAR R2-R14
	LDI  R24,13
	LDI  R26,2
	CLR  R27
__CLEAR_REG:
	ST   X+,R30
	DEC  R24
	BRNE __CLEAR_REG

;CLEAR SRAM
	LDI  R24,LOW(0x800)
	LDI  R25,HIGH(0x800)
	LDI  R26,0x60
__CLEAR_SRAM:
	ST   X+,R30
	SBIW R24,1
	BRNE __CLEAR_SRAM

;GLOBAL VARIABLES INITIALIZATION
	LDI  R30,LOW(__GLOBAL_INI_TBL*2)
	LDI  R31,HIGH(__GLOBAL_INI_TBL*2)
__GLOBAL_INI_NEXT:
	LPM  R24,Z+
	LPM  R25,Z+
	SBIW R24,0
	BREQ __GLOBAL_INI_END
	LPM  R26,Z+
	LPM  R27,Z+
	LPM  R0,Z+
	LPM  R1,Z+
	MOVW R22,R30
	MOVW R30,R0
__GLOBAL_INI_LOOP:
	LPM  R0,Z+
	ST   X+,R0
	SBIW R24,1
	BRNE __GLOBAL_INI_LOOP
	MOVW R30,R22
	RJMP __GLOBAL_INI_NEXT
__GLOBAL_INI_END:

;STACK POINTER INITIALIZATION
	LDI  R30,LOW(0x85F)
	OUT  SPL,R30
	LDI  R30,HIGH(0x85F)
	OUT  SPH,R30

;DATA STACK POINTER INITIALIZATION
	LDI  R28,LOW(0x260)
	LDI  R29,HIGH(0x260)

	JMP  _main

	.ESEG
	.ORG 0

	.DSEG
	.ORG 0x260
;       1 /*****************************************************
;       2 This program was produced by the
;       3 CodeWizardAVR V1.25.9 Standard
;       4 Automatic Program Generator
;       5  Copyright 1998-2008 Pavel Haiduc, HP InfoTech s.r.l.
;       6 http://www.hpinfotech.com
;       7 
;       8 Project : ternary dac 5bit 243step
;       9 Version :
;      10 Date    : 18.04.2010
;      11 Author  : F4CG
;      12 Company : F4CG
;      13 Comments:
;      14 
;      15 
;      16 Chip type           : ATmega32
;      17 Program type        : Application
;      18 Clock frequency     : 4,000000 MHz
;      19 Memory model        : Small
;      20 External SRAM size  : 0
;      21 Data Stack size     : 512
;      22 *****************************************************/
;      23 
;      24 #include <mega32.h>
;      25 	#ifndef __SLEEP_DEFINED__
	#ifndef __SLEEP_DEFINED__
;      26 	#define __SLEEP_DEFINED__
	#define __SLEEP_DEFINED__
;      27 	.EQU __se_bit=0x80
	.EQU __se_bit=0x80
;      28 	.EQU __sm_mask=0x70
	.EQU __sm_mask=0x70
;      29 	.EQU __sm_powerdown=0x20
	.EQU __sm_powerdown=0x20
;      30 	.EQU __sm_powersave=0x30
	.EQU __sm_powersave=0x30
;      31 	.EQU __sm_standby=0x60
	.EQU __sm_standby=0x60
;      32 	.EQU __sm_ext_standby=0x70
	.EQU __sm_ext_standby=0x70
;      33 	.EQU __sm_adc_noise_red=0x10
	.EQU __sm_adc_noise_red=0x10
;      34 	.SET power_ctrl_reg=mcucr
	.SET power_ctrl_reg=mcucr
;      35 	#endif
	#endif
;      36 #include <delay.h>
;      37 
;      38 // Declare your global variables here
;      39 
;      40 void main(void)
;      41 {

	.CSEG
_main:
;      42 // Declare your local variables here
;      43 
;      44 // Input/Output Ports initialization
;      45 // Port A initialization
;      46 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;      47 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;      48 PORTA=0x00;
	LDI  R30,LOW(0)
	OUT  0x1B,R30
;      49 DDRA=0x00;
	OUT  0x1A,R30
;      50 
;      51 // Port B initialization
;      52 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;      53 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;      54 PORTB=0x00;
	OUT  0x18,R30
;      55 DDRB=0x00;
	OUT  0x17,R30
;      56 
;      57 // Port C initialization
;      58 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;      59 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;      60 PORTC=0x00;
	OUT  0x15,R30
;      61 DDRC=0x00;
	OUT  0x14,R30
;      62 
;      63 // Port D initialization
;      64 // Func7=In Func6=In Func5=In Func4=In Func3=In Func2=In Func1=In Func0=In
;      65 // State7=T State6=T State5=T State4=T State3=T State2=T State1=T State0=T
;      66 PORTD=0x00;
	OUT  0x12,R30
;      67 DDRD=0x00;
	OUT  0x11,R30
;      68 
;      69 // Timer/Counter 0 initialization
;      70 // Clock source: System Clock
;      71 // Clock value: Timer 0 Stopped
;      72 // Mode: Normal top=FFh
;      73 // OC0 output: Disconnected
;      74 TCCR0=0x00;
	OUT  0x33,R30
;      75 TCNT0=0x00;
	OUT  0x32,R30
;      76 OCR0=0x00;
	OUT  0x3C,R30
;      77 
;      78 // Timer/Counter 1 initialization
;      79 // Clock source: System Clock
;      80 // Clock value: Timer 1 Stopped
;      81 // Mode: Normal top=FFFFh
;      82 // OC1A output: Discon.
;      83 // OC1B output: Discon.
;      84 // Noise Canceler: Off
;      85 // Input Capture on Falling Edge
;      86 // Timer 1 Overflow Interrupt: Off
;      87 // Input Capture Interrupt: Off
;      88 // Compare A Match Interrupt: Off
;      89 // Compare B Match Interrupt: Off
;      90 TCCR1A=0x00;
	OUT  0x2F,R30
;      91 TCCR1B=0x00;
	OUT  0x2E,R30
;      92 TCNT1H=0x00;
	OUT  0x2D,R30
;      93 TCNT1L=0x00;
	OUT  0x2C,R30
;      94 ICR1H=0x00;
	OUT  0x27,R30
;      95 ICR1L=0x00;
	OUT  0x26,R30
;      96 OCR1AH=0x00;
	OUT  0x2B,R30
;      97 OCR1AL=0x00;
	OUT  0x2A,R30
;      98 OCR1BH=0x00;
	OUT  0x29,R30
;      99 OCR1BL=0x00;
	OUT  0x28,R30
;     100 
;     101 // Timer/Counter 2 initialization
;     102 // Clock source: System Clock
;     103 // Clock value: Timer 2 Stopped
;     104 // Mode: Normal top=FFh
;     105 // OC2 output: Disconnected
;     106 ASSR=0x00;
	OUT  0x22,R30
;     107 TCCR2=0x00;
	OUT  0x25,R30
;     108 TCNT2=0x00;
	OUT  0x24,R30
;     109 OCR2=0x00;
	OUT  0x23,R30
;     110 
;     111 // External Interrupt(s) initialization
;     112 // INT0: Off
;     113 // INT1: Off
;     114 // INT2: Off
;     115 MCUCR=0x00;
	OUT  0x35,R30
;     116 MCUCSR=0x00;
	OUT  0x34,R30
;     117 
;     118 // Timer(s)/Counter(s) Interrupt(s) initialization
;     119 TIMSK=0x00;
	OUT  0x39,R30
;     120 
;     121 // Analog Comparator initialization
;     122 // Analog Comparator: Off
;     123 // Analog Comparator Input Capture by Timer/Counter 1: Off
;     124 ACSR=0x80;
	LDI  R30,LOW(128)
	OUT  0x8,R30
;     125 SFIOR=0x00;
	LDI  R30,LOW(0)
	OUT  0x30,R30
;     126 
;     127 while (1)
;     128       {
;     129       // Place your code here
;     130 start:
_0x6:
;     131 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x0
;     132 PORTA=0x00;
;     133 delay_ms(500);
;     134 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x0
;     135 PORTA=0x00;
;     136 delay_ms(500);
;     137 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x1
;     138 PORTA=0x01;
;     139 delay_ms(500);
;     140 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x0
;     141 PORTA=0x00;
;     142 delay_ms(500);
;     143 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0x0
;     144 PORTA=0x00;
;     145 delay_ms(500);
;     146 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x1
;     147 PORTA=0x01;
;     148 delay_ms(500);
;     149 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x2
;     150 PORTA=0x02;
;     151 delay_ms(500);
;     152 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x2
;     153 PORTA=0x02;
;     154 delay_ms(500);
;     155 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x3
;     156 PORTA=0x03;
;     157 delay_ms(500);
;     158 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x0
;     159 PORTA=0x00;
;     160 delay_ms(500);
;     161 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0x0
;     162 PORTA=0x00;
;     163 delay_ms(500);
;     164 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x1
;     165 PORTA=0x01;
;     166 delay_ms(500);
;     167 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x0
;     168 PORTA=0x00;
;     169 delay_ms(500);
;     170 DDRA=0x18;
	LDI  R30,LOW(24)
	RCALL SUBOPT_0x0
;     171 PORTA=0x00;
;     172 delay_ms(500);
;     173 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x1
;     174 PORTA=0x01;
;     175 delay_ms(500);
;     176 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x2
;     177 PORTA=0x02;
;     178 delay_ms(500);
;     179 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0x2
;     180 PORTA=0x02;
;     181 delay_ms(500);
;     182 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x3
;     183 PORTA=0x03;
;     184 delay_ms(500);
;     185 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x4
;     186 PORTA=0x04;
;     187 delay_ms(500);
;     188 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x4
;     189 PORTA=0x04;
;     190 delay_ms(500);
;     191 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x5
;     192 PORTA=0x05;
;     193 delay_ms(500);
;     194 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x4
;     195 PORTA=0x04;
;     196 delay_ms(500);
;     197 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0x4
;     198 PORTA=0x04;
;     199 delay_ms(500);
;     200 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x5
;     201 PORTA=0x05;
;     202 delay_ms(500);
;     203 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x6
;     204 PORTA=0x06;
;     205 delay_ms(500);
;     206 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x6
;     207 PORTA=0x06;
;     208 delay_ms(500);
;     209 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x7
;     210 PORTA=0x07;
;     211 delay_ms(500);
;     212 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x0
;     213 PORTA=0x00;
;     214 delay_ms(500);
;     215 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x0
;     216 PORTA=0x00;
;     217 delay_ms(500);
;     218 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x1
;     219 PORTA=0x01;
;     220 delay_ms(500);
;     221 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x0
;     222 PORTA=0x00;
;     223 delay_ms(500);
;     224 DDRA=0x14;
	LDI  R30,LOW(20)
	RCALL SUBOPT_0x0
;     225 PORTA=0x00;
;     226 delay_ms(500);
;     227 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x1
;     228 PORTA=0x01;
;     229 delay_ms(500);
;     230 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x2
;     231 PORTA=0x02;
;     232 delay_ms(500);
;     233 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x2
;     234 PORTA=0x02;
;     235 delay_ms(500);
;     236 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x3
;     237 PORTA=0x03;
;     238 delay_ms(500);
;     239 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x0
;     240 PORTA=0x00;
;     241 delay_ms(500);
;     242 DDRA=0x12;
	LDI  R30,LOW(18)
	RCALL SUBOPT_0x0
;     243 PORTA=0x00;
;     244 delay_ms(500);
;     245 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x1
;     246 PORTA=0x01;
;     247 delay_ms(500);
;     248 DDRA=0x11;
	LDI  R30,LOW(17)
	RCALL SUBOPT_0x0
;     249 PORTA=0x00;
;     250 delay_ms(500);
;     251 DDRA=0x10;
	LDI  R30,LOW(16)
	RCALL SUBOPT_0x0
;     252 PORTA=0x00;
;     253 delay_ms(500);
;     254 DDRA=0x11;
	LDI  R30,LOW(17)
	RCALL SUBOPT_0x1
;     255 PORTA=0x01;
;     256 delay_ms(500);
;     257 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x2
;     258 PORTA=0x02;
;     259 delay_ms(500);
;     260 DDRA=0x12;
	LDI  R30,LOW(18)
	RCALL SUBOPT_0x2
;     261 PORTA=0x02;
;     262 delay_ms(500);
;     263 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x3
;     264 PORTA=0x03;
;     265 delay_ms(500);
;     266 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x4
;     267 PORTA=0x04;
;     268 delay_ms(500);
;     269 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x4
;     270 PORTA=0x04;
;     271 delay_ms(500);
;     272 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x5
;     273 PORTA=0x05;
;     274 delay_ms(500);
;     275 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x4
;     276 PORTA=0x04;
;     277 delay_ms(500);
;     278 DDRA=0x14;
	LDI  R30,LOW(20)
	RCALL SUBOPT_0x4
;     279 PORTA=0x04;
;     280 delay_ms(500);
;     281 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x5
;     282 PORTA=0x05;
;     283 delay_ms(500);
;     284 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x6
;     285 PORTA=0x06;
;     286 delay_ms(500);
;     287 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x6
;     288 PORTA=0x06;
;     289 delay_ms(500);
;     290 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x7
;     291 PORTA=0x07;
;     292 delay_ms(500);
;     293 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x8
;     294 PORTA=0x08;
;     295 delay_ms(500);
;     296 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x8
;     297 PORTA=0x08;
;     298 delay_ms(500);
;     299 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x9
;     300 PORTA=0x09;
;     301 delay_ms(500);
;     302 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x8
;     303 PORTA=0x08;
;     304 delay_ms(500);
;     305 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0x8
;     306 PORTA=0x08;
;     307 delay_ms(500);
;     308 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x9
;     309 PORTA=0x09;
;     310 delay_ms(500);
;     311 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0xA
;     312 PORTA=0x0A;
;     313 delay_ms(500);
;     314 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0xA
;     315 PORTA=0x0A;
;     316 delay_ms(500);
;     317 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0xB
;     318 PORTA=0x0B;
;     319 delay_ms(500);
;     320 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x8
;     321 PORTA=0x08;
;     322 delay_ms(500);
;     323 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0x8
;     324 PORTA=0x08;
;     325 delay_ms(500);
;     326 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x9
;     327 PORTA=0x09;
;     328 delay_ms(500);
;     329 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x8
;     330 PORTA=0x08;
;     331 delay_ms(500);
;     332 DDRA=0x18;
	LDI  R30,LOW(24)
	RCALL SUBOPT_0x8
;     333 PORTA=0x08;
;     334 delay_ms(500);
;     335 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x9
;     336 PORTA=0x09;
;     337 delay_ms(500);
;     338 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0xA
;     339 PORTA=0x0A;
;     340 delay_ms(500);
;     341 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0xA
;     342 PORTA=0x0A;
;     343 delay_ms(500);
;     344 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0xB
;     345 PORTA=0x0B;
;     346 delay_ms(500);
;     347 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0xC
;     348 PORTA=0x0C;
;     349 delay_ms(500);
;     350 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0xC
;     351 PORTA=0x0C;
;     352 delay_ms(500);
;     353 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0xD
;     354 PORTA=0x0D;
;     355 delay_ms(500);
;     356 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0xC
;     357 PORTA=0x0C;
;     358 delay_ms(500);
;     359 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0xC
;     360 PORTA=0x0C;
;     361 delay_ms(500);
;     362 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0xD
;     363 PORTA=0x0D;
;     364 delay_ms(500);
;     365 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0xE
;     366 PORTA=0x0E;
;     367 delay_ms(500);
;     368 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0xE
;     369 PORTA=0x0E;
;     370 delay_ms(500);
;     371 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0xF
;     372 PORTA=0x0F;
;     373 delay_ms(500);
;     374 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x0
;     375 PORTA=0x00;
;     376 delay_ms(500);
;     377 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0x0
;     378 PORTA=0x00;
;     379 delay_ms(500);
;     380 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x1
;     381 PORTA=0x01;
;     382 delay_ms(500);
;     383 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0x0
;     384 PORTA=0x00;
;     385 delay_ms(500);
;     386 DDRA=0x0C;
	LDI  R30,LOW(12)
	RCALL SUBOPT_0x0
;     387 PORTA=0x00;
;     388 delay_ms(500);
;     389 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0x1
;     390 PORTA=0x01;
;     391 delay_ms(500);
;     392 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x2
;     393 PORTA=0x02;
;     394 delay_ms(500);
;     395 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0x2
;     396 PORTA=0x02;
;     397 delay_ms(500);
;     398 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x3
;     399 PORTA=0x03;
;     400 delay_ms(500);
;     401 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0x0
;     402 PORTA=0x00;
;     403 delay_ms(500);
;     404 DDRA=0x0A;
	LDI  R30,LOW(10)
	RCALL SUBOPT_0x0
;     405 PORTA=0x00;
;     406 delay_ms(500);
;     407 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0x1
;     408 PORTA=0x01;
;     409 delay_ms(500);
;     410 DDRA=0x09;
	LDI  R30,LOW(9)
	RCALL SUBOPT_0x0
;     411 PORTA=0x00;
;     412 delay_ms(500);
;     413 DDRA=0x08;
	LDI  R30,LOW(8)
	RCALL SUBOPT_0x0
;     414 PORTA=0x00;
;     415 delay_ms(500);
;     416 DDRA=0x09;
	LDI  R30,LOW(9)
	RCALL SUBOPT_0x1
;     417 PORTA=0x01;
;     418 delay_ms(500);
;     419 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0x2
;     420 PORTA=0x02;
;     421 delay_ms(500);
;     422 DDRA=0x0A;
	LDI  R30,LOW(10)
	RCALL SUBOPT_0x2
;     423 PORTA=0x02;
;     424 delay_ms(500);
;     425 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0x3
;     426 PORTA=0x03;
;     427 delay_ms(500);
;     428 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x4
;     429 PORTA=0x04;
;     430 delay_ms(500);
;     431 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0x4
;     432 PORTA=0x04;
;     433 delay_ms(500);
;     434 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x5
;     435 PORTA=0x05;
;     436 delay_ms(500);
;     437 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0x4
;     438 PORTA=0x04;
;     439 delay_ms(500);
;     440 DDRA=0x0C;
	LDI  R30,LOW(12)
	RCALL SUBOPT_0x4
;     441 PORTA=0x04;
;     442 delay_ms(500);
;     443 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0x5
;     444 PORTA=0x05;
;     445 delay_ms(500);
;     446 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x6
;     447 PORTA=0x06;
;     448 delay_ms(500);
;     449 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0x6
;     450 PORTA=0x06;
;     451 delay_ms(500);
;     452 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x7
;     453 PORTA=0x07;
;     454 delay_ms(500);
;     455 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x0
;     456 PORTA=0x00;
;     457 delay_ms(500);
;     458 DDRA=0x06;
	LDI  R30,LOW(6)
	RCALL SUBOPT_0x0
;     459 PORTA=0x00;
;     460 delay_ms(500);
;     461 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x1
;     462 PORTA=0x01;
;     463 delay_ms(500);
;     464 DDRA=0x05;
	LDI  R30,LOW(5)
	RCALL SUBOPT_0x0
;     465 PORTA=0x00;
;     466 delay_ms(500);
;     467 DDRA=0x04;
	LDI  R30,LOW(4)
	RCALL SUBOPT_0x0
;     468 PORTA=0x00;
;     469 delay_ms(500);
;     470 DDRA=0x05;
	LDI  R30,LOW(5)
	RCALL SUBOPT_0x1
;     471 PORTA=0x01;
;     472 delay_ms(500);
;     473 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x2
;     474 PORTA=0x02;
;     475 delay_ms(500);
;     476 DDRA=0x06;
	LDI  R30,LOW(6)
	RCALL SUBOPT_0x2
;     477 PORTA=0x02;
;     478 delay_ms(500);
;     479 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x3
;     480 PORTA=0x03;
;     481 delay_ms(500);
;     482 DDRA=0x03;
	LDI  R30,LOW(3)
	RCALL SUBOPT_0x0
;     483 PORTA=0x00;
;     484 delay_ms(500);
;     485 DDRA=0x02;
	LDI  R30,LOW(2)
	RCALL SUBOPT_0x0
;     486 PORTA=0x00;
;     487 delay_ms(500);
;     488 DDRA=0x03;
	LDI  R30,LOW(3)
	RCALL SUBOPT_0x1
;     489 PORTA=0x01;
;     490 delay_ms(500);
;     491 DDRA=0x01;
	LDI  R30,LOW(1)
	RCALL SUBOPT_0x0
;     492 PORTA=0x00;
;     493 delay_ms(500);
;     494 DDRA=0x00;
	LDI  R30,LOW(0)
	RCALL SUBOPT_0x0
;     495 PORTA=0x00;
;     496 delay_ms(500);
;     497 DDRA=0x01;
	LDI  R30,LOW(1)
	RCALL SUBOPT_0x1
;     498 PORTA=0x01;
;     499 delay_ms(500);
;     500 DDRA=0x03;
	LDI  R30,LOW(3)
	RCALL SUBOPT_0x2
;     501 PORTA=0x02;
;     502 delay_ms(500);
;     503 DDRA=0x02;
	LDI  R30,LOW(2)
	RCALL SUBOPT_0x2
;     504 PORTA=0x02;
;     505 delay_ms(500);
;     506 DDRA=0x03;
	LDI  R30,LOW(3)
	RCALL SUBOPT_0x3
;     507 PORTA=0x03;
;     508 delay_ms(500);
;     509 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x4
;     510 PORTA=0x04;
;     511 delay_ms(500);
;     512 DDRA=0x06;
	LDI  R30,LOW(6)
	RCALL SUBOPT_0x4
;     513 PORTA=0x04;
;     514 delay_ms(500);
;     515 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x5
;     516 PORTA=0x05;
;     517 delay_ms(500);
;     518 DDRA=0x05;
	LDI  R30,LOW(5)
	RCALL SUBOPT_0x4
;     519 PORTA=0x04;
;     520 delay_ms(500);
;     521 DDRA=0x04;
	LDI  R30,LOW(4)
	RCALL SUBOPT_0x4
;     522 PORTA=0x04;
;     523 delay_ms(500);
;     524 DDRA=0x05;
	LDI  R30,LOW(5)
	RCALL SUBOPT_0x5
;     525 PORTA=0x05;
;     526 delay_ms(500);
;     527 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x6
;     528 PORTA=0x06;
;     529 delay_ms(500);
;     530 DDRA=0x06;
	LDI  R30,LOW(6)
	RCALL SUBOPT_0x6
;     531 PORTA=0x06;
;     532 delay_ms(500);
;     533 DDRA=0x07;
	LDI  R30,LOW(7)
	RCALL SUBOPT_0x7
;     534 PORTA=0x07;
;     535 delay_ms(500);
;     536 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x8
;     537 PORTA=0x08;
;     538 delay_ms(500);
;     539 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0x8
;     540 PORTA=0x08;
;     541 delay_ms(500);
;     542 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0x9
;     543 PORTA=0x09;
;     544 delay_ms(500);
;     545 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0x8
;     546 PORTA=0x08;
;     547 delay_ms(500);
;     548 DDRA=0x0C;
	LDI  R30,LOW(12)
	RCALL SUBOPT_0x8
;     549 PORTA=0x08;
;     550 delay_ms(500);
;     551 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0x9
;     552 PORTA=0x09;
;     553 delay_ms(500);
;     554 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0xA
;     555 PORTA=0x0A;
;     556 delay_ms(500);
;     557 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0xA
;     558 PORTA=0x0A;
;     559 delay_ms(500);
;     560 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0xB
;     561 PORTA=0x0B;
;     562 delay_ms(500);
;     563 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0x8
;     564 PORTA=0x08;
;     565 delay_ms(500);
;     566 DDRA=0x0A;
	LDI  R30,LOW(10)
	RCALL SUBOPT_0x8
;     567 PORTA=0x08;
;     568 delay_ms(500);
;     569 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0x9
;     570 PORTA=0x09;
;     571 delay_ms(500);
;     572 DDRA=0x09;
	LDI  R30,LOW(9)
	RCALL SUBOPT_0x8
;     573 PORTA=0x08;
;     574 delay_ms(500);
;     575 DDRA=0x08;
	LDI  R30,LOW(8)
	RCALL SUBOPT_0x8
;     576 PORTA=0x08;
;     577 delay_ms(500);
;     578 DDRA=0x09;
	LDI  R30,LOW(9)
	RCALL SUBOPT_0x9
;     579 PORTA=0x09;
;     580 delay_ms(500);
;     581 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0xA
;     582 PORTA=0x0A;
;     583 delay_ms(500);
;     584 DDRA=0x0A;
	LDI  R30,LOW(10)
	RCALL SUBOPT_0xA
;     585 PORTA=0x0A;
;     586 delay_ms(500);
;     587 DDRA=0x0B;
	LDI  R30,LOW(11)
	RCALL SUBOPT_0xB
;     588 PORTA=0x0B;
;     589 delay_ms(500);
;     590 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0xC
;     591 PORTA=0x0C;
;     592 delay_ms(500);
;     593 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0xC
;     594 PORTA=0x0C;
;     595 delay_ms(500);
;     596 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0xD
;     597 PORTA=0x0D;
;     598 delay_ms(500);
;     599 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0xC
;     600 PORTA=0x0C;
;     601 delay_ms(500);
;     602 DDRA=0x0C;
	LDI  R30,LOW(12)
	RCALL SUBOPT_0xC
;     603 PORTA=0x0C;
;     604 delay_ms(500);
;     605 DDRA=0x0D;
	LDI  R30,LOW(13)
	RCALL SUBOPT_0xD
;     606 PORTA=0x0D;
;     607 delay_ms(500);
;     608 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0xE
;     609 PORTA=0x0E;
;     610 delay_ms(500);
;     611 DDRA=0x0E;
	LDI  R30,LOW(14)
	RCALL SUBOPT_0xE
;     612 PORTA=0x0E;
;     613 delay_ms(500);
;     614 DDRA=0x0F;
	LDI  R30,LOW(15)
	RCALL SUBOPT_0xF
;     615 PORTA=0x0F;
;     616 delay_ms(500);
;     617 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x10
;     618 PORTA=0x10;
;     619 delay_ms(500);
;     620 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x10
;     621 PORTA=0x10;
;     622 delay_ms(500);
;     623 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x11
;     624 PORTA=0x11;
;     625 delay_ms(500);
;     626 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x10
;     627 PORTA=0x10;
;     628 delay_ms(500);
;     629 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0x10
;     630 PORTA=0x10;
;     631 delay_ms(500);
;     632 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x11
;     633 PORTA=0x11;
;     634 delay_ms(500);
;     635 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x12
;     636 PORTA=0x12;
;     637 delay_ms(500);
;     638 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x12
;     639 PORTA=0x12;
;     640 delay_ms(500);
;     641 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x13
;     642 PORTA=0x13;
;     643 delay_ms(500);
;     644 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x10
;     645 PORTA=0x10;
;     646 delay_ms(500);
;     647 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0x10
;     648 PORTA=0x10;
;     649 delay_ms(500);
;     650 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x11
;     651 PORTA=0x11;
;     652 delay_ms(500);
;     653 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x10
;     654 PORTA=0x10;
;     655 delay_ms(500);
;     656 DDRA=0x18;
	LDI  R30,LOW(24)
	RCALL SUBOPT_0x10
;     657 PORTA=0x10;
;     658 delay_ms(500);
;     659 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x11
;     660 PORTA=0x11;
;     661 delay_ms(500);
;     662 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x12
;     663 PORTA=0x12;
;     664 delay_ms(500);
;     665 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0x12
;     666 PORTA=0x12;
;     667 delay_ms(500);
;     668 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x13
;     669 PORTA=0x13;
;     670 delay_ms(500);
;     671 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x14
;     672 PORTA=0x14;
;     673 delay_ms(500);
;     674 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x14
;     675 PORTA=0x14;
;     676 delay_ms(500);
;     677 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x15
;     678 PORTA=0x15;
;     679 delay_ms(500);
;     680 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x14
;     681 PORTA=0x14;
;     682 delay_ms(500);
;     683 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0x14
;     684 PORTA=0x14;
;     685 delay_ms(500);
;     686 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x15
;     687 PORTA=0x15;
;     688 delay_ms(500);
;     689 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x16
;     690 PORTA=0x16;
;     691 delay_ms(500);
;     692 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x16
;     693 PORTA=0x16;
;     694 delay_ms(500);
;     695 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x17
;     696 PORTA=0x17;
;     697 delay_ms(500);
;     698 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x10
;     699 PORTA=0x10;
;     700 delay_ms(500);
;     701 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x10
;     702 PORTA=0x10;
;     703 delay_ms(500);
;     704 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x11
;     705 PORTA=0x11;
;     706 delay_ms(500);
;     707 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x10
;     708 PORTA=0x10;
;     709 delay_ms(500);
;     710 DDRA=0x14;
	LDI  R30,LOW(20)
	RCALL SUBOPT_0x10
;     711 PORTA=0x10;
;     712 delay_ms(500);
;     713 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x11
;     714 PORTA=0x11;
;     715 delay_ms(500);
;     716 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x12
;     717 PORTA=0x12;
;     718 delay_ms(500);
;     719 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x12
;     720 PORTA=0x12;
;     721 delay_ms(500);
;     722 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x13
;     723 PORTA=0x13;
;     724 delay_ms(500);
;     725 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x10
;     726 PORTA=0x10;
;     727 delay_ms(500);
;     728 DDRA=0x12;
	LDI  R30,LOW(18)
	RCALL SUBOPT_0x10
;     729 PORTA=0x10;
;     730 delay_ms(500);
;     731 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x11
;     732 PORTA=0x11;
;     733 delay_ms(500);
;     734 DDRA=0x11;
	LDI  R30,LOW(17)
	RCALL SUBOPT_0x10
;     735 PORTA=0x10;
;     736 delay_ms(500);
;     737 DDRA=0x10;
	LDI  R30,LOW(16)
	RCALL SUBOPT_0x10
;     738 PORTA=0x10;
;     739 delay_ms(500);
;     740 DDRA=0x11;
	LDI  R30,LOW(17)
	RCALL SUBOPT_0x11
;     741 PORTA=0x11;
;     742 delay_ms(500);
;     743 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x12
;     744 PORTA=0x12;
;     745 delay_ms(500);
;     746 DDRA=0x12;
	LDI  R30,LOW(18)
	RCALL SUBOPT_0x12
;     747 PORTA=0x12;
;     748 delay_ms(500);
;     749 DDRA=0x13;
	LDI  R30,LOW(19)
	RCALL SUBOPT_0x13
;     750 PORTA=0x13;
;     751 delay_ms(500);
;     752 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x14
;     753 PORTA=0x14;
;     754 delay_ms(500);
;     755 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x14
;     756 PORTA=0x14;
;     757 delay_ms(500);
;     758 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x15
;     759 PORTA=0x15;
;     760 delay_ms(500);
;     761 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x14
;     762 PORTA=0x14;
;     763 delay_ms(500);
;     764 DDRA=0x14;
	LDI  R30,LOW(20)
	RCALL SUBOPT_0x14
;     765 PORTA=0x14;
;     766 delay_ms(500);
;     767 DDRA=0x15;
	LDI  R30,LOW(21)
	RCALL SUBOPT_0x15
;     768 PORTA=0x15;
;     769 delay_ms(500);
;     770 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x16
;     771 PORTA=0x16;
;     772 delay_ms(500);
;     773 DDRA=0x16;
	LDI  R30,LOW(22)
	RCALL SUBOPT_0x16
;     774 PORTA=0x16;
;     775 delay_ms(500);
;     776 DDRA=0x17;
	LDI  R30,LOW(23)
	RCALL SUBOPT_0x17
;     777 PORTA=0x17;
;     778 delay_ms(500);
;     779 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x18
;     780 PORTA=0x18;
;     781 delay_ms(500);
;     782 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x18
;     783 PORTA=0x18;
;     784 delay_ms(500);
;     785 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x19
;     786 PORTA=0x19;
;     787 delay_ms(500);
;     788 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x18
;     789 PORTA=0x18;
;     790 delay_ms(500);
;     791 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0x18
;     792 PORTA=0x18;
;     793 delay_ms(500);
;     794 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x19
;     795 PORTA=0x19;
;     796 delay_ms(500);
;     797 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x1A
;     798 PORTA=0x1A;
;     799 delay_ms(500);
;     800 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x1A
;     801 PORTA=0x1A;
;     802 delay_ms(500);
;     803 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x1B
;     804 PORTA=0x1B;
;     805 delay_ms(500);
;     806 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x18
;     807 PORTA=0x18;
;     808 delay_ms(500);
;     809 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0x18
;     810 PORTA=0x18;
;     811 delay_ms(500);
;     812 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x19
;     813 PORTA=0x19;
;     814 delay_ms(500);
;     815 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x18
;     816 PORTA=0x18;
;     817 delay_ms(500);
;     818 DDRA=0x18;
	LDI  R30,LOW(24)
	RCALL SUBOPT_0x18
;     819 PORTA=0x18;
;     820 delay_ms(500);
;     821 DDRA=0x19;
	LDI  R30,LOW(25)
	RCALL SUBOPT_0x19
;     822 PORTA=0x19;
;     823 delay_ms(500);
;     824 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x1A
;     825 PORTA=0x1A;
;     826 delay_ms(500);
;     827 DDRA=0x1A;
	LDI  R30,LOW(26)
	RCALL SUBOPT_0x1A
;     828 PORTA=0x1A;
;     829 delay_ms(500);
;     830 DDRA=0x1B;
	LDI  R30,LOW(27)
	RCALL SUBOPT_0x1B
;     831 PORTA=0x1B;
;     832 delay_ms(500);
;     833 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x1C
;     834 PORTA=0x1C;
;     835 delay_ms(500);
;     836 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x1C
;     837 PORTA=0x1C;
;     838 delay_ms(500);
;     839 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x1D
;     840 PORTA=0x1D;
;     841 delay_ms(500);
;     842 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x1C
;     843 PORTA=0x1C;
;     844 delay_ms(500);
;     845 DDRA=0x1C;
	LDI  R30,LOW(28)
	RCALL SUBOPT_0x1C
;     846 PORTA=0x1C;
;     847 delay_ms(500);
;     848 DDRA=0x1D;
	LDI  R30,LOW(29)
	RCALL SUBOPT_0x1D
;     849 PORTA=0x1D;
;     850 delay_ms(500);
;     851 DDRA=0x1F;
	LDI  R30,LOW(31)
	RCALL SUBOPT_0x1E
;     852 PORTA=0x1E;
;     853 delay_ms(500);
;     854 DDRA=0x1E;
	LDI  R30,LOW(30)
	RCALL SUBOPT_0x1E
;     855 PORTA=0x1E;
;     856 delay_ms(500);
;     857 DDRA=0x1F;
	LDI  R30,LOW(31)
	OUT  0x1A,R30
;     858 PORTA=0x1F;
	OUT  0x1B,R30
;     859 delay_ms(500);
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	CALL _delay_ms
;     860 goto start;
	RJMP _0x6
;     861       };
;     862 }
_0x7:
	RJMP _0x7


;OPTIMIZER ADDED SUBROUTINE, CALLED 32 TIMES, CODE SIZE REDUCTION:214 WORDS
SUBOPT_0x0:
	OUT  0x1A,R30
	LDI  R30,LOW(0)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 16 TIMES, CODE SIZE REDUCTION:102 WORDS
SUBOPT_0x1:
	OUT  0x1A,R30
	LDI  R30,LOW(1)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 16 TIMES, CODE SIZE REDUCTION:102 WORDS
SUBOPT_0x2:
	OUT  0x1A,R30
	LDI  R30,LOW(2)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x3:
	OUT  0x1A,R30
	LDI  R30,LOW(3)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 16 TIMES, CODE SIZE REDUCTION:102 WORDS
SUBOPT_0x4:
	OUT  0x1A,R30
	LDI  R30,LOW(4)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x5:
	OUT  0x1A,R30
	LDI  R30,LOW(5)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x6:
	OUT  0x1A,R30
	LDI  R30,LOW(6)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x7:
	OUT  0x1A,R30
	LDI  R30,LOW(7)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 16 TIMES, CODE SIZE REDUCTION:102 WORDS
SUBOPT_0x8:
	OUT  0x1A,R30
	LDI  R30,LOW(8)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x9:
	OUT  0x1A,R30
	LDI  R30,LOW(9)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0xA:
	OUT  0x1A,R30
	LDI  R30,LOW(10)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0xB:
	OUT  0x1A,R30
	LDI  R30,LOW(11)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0xC:
	OUT  0x1A,R30
	LDI  R30,LOW(12)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0xD:
	OUT  0x1A,R30
	LDI  R30,LOW(13)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0xE:
	OUT  0x1A,R30
	LDI  R30,LOW(14)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0xF:
	OUT  0x1A,R30
	LDI  R30,LOW(15)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 16 TIMES, CODE SIZE REDUCTION:102 WORDS
SUBOPT_0x10:
	OUT  0x1A,R30
	LDI  R30,LOW(16)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x11:
	OUT  0x1A,R30
	LDI  R30,LOW(17)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x12:
	OUT  0x1A,R30
	LDI  R30,LOW(18)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x13:
	OUT  0x1A,R30
	LDI  R30,LOW(19)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x14:
	OUT  0x1A,R30
	LDI  R30,LOW(20)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x15:
	OUT  0x1A,R30
	LDI  R30,LOW(21)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x16:
	OUT  0x1A,R30
	LDI  R30,LOW(22)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x17:
	OUT  0x1A,R30
	LDI  R30,LOW(23)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 8 TIMES, CODE SIZE REDUCTION:46 WORDS
SUBOPT_0x18:
	OUT  0x1A,R30
	LDI  R30,LOW(24)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x19:
	OUT  0x1A,R30
	LDI  R30,LOW(25)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x1A:
	OUT  0x1A,R30
	LDI  R30,LOW(26)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1B:
	OUT  0x1A,R30
	LDI  R30,LOW(27)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 4 TIMES, CODE SIZE REDUCTION:18 WORDS
SUBOPT_0x1C:
	OUT  0x1A,R30
	LDI  R30,LOW(28)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1D:
	OUT  0x1A,R30
	LDI  R30,LOW(29)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

;OPTIMIZER ADDED SUBROUTINE, CALLED 2 TIMES, CODE SIZE REDUCTION:4 WORDS
SUBOPT_0x1E:
	OUT  0x1A,R30
	LDI  R30,LOW(30)
	OUT  0x1B,R30
	LDI  R30,LOW(500)
	LDI  R31,HIGH(500)
	ST   -Y,R31
	ST   -Y,R30
	JMP  _delay_ms

_delay_ms:
	ld   r30,y+
	ld   r31,y+
	adiw r30,0
	breq __delay_ms1
__delay_ms0:
	__DELAY_USW 0x3E8
	wdr
	sbiw r30,1
	brne __delay_ms0
__delay_ms1:
	ret

;END OF CODE MARKER
__END_OF_CODE:
